untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwWFy/pjRG5l8cLMwjC8HsZRw8Js8HqnihwnxwJXp03zUOCLDAnKo0tlX/vrJBgdhxGqo0QtpG49+k3e3tfM6vA8=

OpenBSD 5.9 errata 30, Oct 10, 2016:

A protocol parsing bug in sshd can lead to unauthenticated memory
and CPU consumption.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 030_ssh_kexinit.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install sshd:
    cd /usr/src/usr.bin/ssh
    make obj
    make depend
    make
    make install

Index: usr.bin/ssh/kex.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/kex.c,v
retrieving revision 1.117
retrieving revision 1.117.2.1
diff -p -u -IOpenBSD -r1.117 -r1.117.2.1
--- usr.bin/ssh/kex.c	8 Feb 2016 10:57:07 -0000	1.117
+++ usr.bin/ssh/kex.c	10 Oct 2016 19:37:33 -0000	1.117.2.1
@@ -449,6 +449,7 @@ kex_input_kexinit(int type, u_int32_t se
 	if (kex == NULL)
 		return SSH_ERR_INVALID_ARGUMENT;
 
+	ssh_dispatch_set(ssh, SSH2_MSG_KEXINIT, NULL);
 	ptr = sshpkt_ptr(ssh, &dlen);
 	if ((r = sshbuf_put(kex->peer, ptr, dlen)) != 0)
 		return r;
